<?php
date_default_timezone_set("Asia/Tehran");

$blockFile = __DIR__ . '/block.json';
$requestFile = __DIR__ . '/requests.json';
$block = 0;
$maxRequests = 3; 

if (file_exists($blockFile)) {
    $blockData = json_decode(file_get_contents($blockFile), true);
    $block = isset($blockData['block_until']) ? intval($blockData['block_until']) : 0;
}

$now = time();
if ($block > $now) {
    echo "⛔ هنوز در بازه بلاک هستیم تا <br>" . date("Y-m-d H:i:s", $block) . "\n";
    exit;
}
if ($block !== 0 && $now >= $block) {
    file_put_contents($blockFile, json_encode(['block_until' => 0], JSON_PRETTY_PRINT));
}

if (file_exists($requestFile)) {
    $requestData = json_decode(file_get_contents($requestFile), true);
    $recentRequests = array_filter($requestData, function ($timestamp) use ($now) {
        return ($now - $timestamp) <= 600; 
    });

    if (count($recentRequests) >= $maxRequests) {
        echo "🚫 بیش از ۳ درخواست در ده دقیقه اخیر ارسال شده. لطفاً صبر کنید.\n";
        exit;
    }
} else {
    $recentRequests = [];
}


$checkUrl = "https://matrahco.ir/pythonapi/";
$checkResp = file_get_contents($checkUrl);
$checkData = json_decode($checkResp, true);

if (isset($checkData['status']) && $checkData['status'] == '401' ) {
    $url = "http://matrahco.ir/pythonapi/req";
    $response = file_get_contents("$url");
    // $ch = curl_init($url);
    // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // $response = curl_exec($ch);
    // curl_close($ch);
    
    $recentRequests[] = $now;
    file_put_contents($requestFile, json_encode($recentRequests, JSON_PRETTY_PRINT));
    
    $data = json_decode($response, true);
    
    if (isset($data['type']) && $data['type'] == 'USE_SMS') {
        echo "✅ درخواست موفق بود، کد ارسال شد.\n";
    } else {
        $blockUntil = $now + (130 * 60); 
        file_put_contents($blockFile, json_encode(['block_until' => $blockUntil], JSON_PRETTY_PRINT));
        echo "🚫 درخواست ناموفق بود. بلاک تا:<br> " . date("Y-m-d H:i:s", $blockUntil) . "\n";
    }
}else{
    echo "مشکلی نیست حاجی جان";
}


?>
